Attribute VB_Name = "modColors"
Option Explicit

'Event GUI Custom Colors

Public COLORS             As GUICLRS
Public Type GUICLRS
    'Battle.net
    ID_COLOR_INFO       As Long 'EVENT SID_INFO
    ID_COLOR_EMOTE      As Long 'EVENT SID_EMOTE
    ID_COLOR_TALK       As Long 'EVENT SID_TALK
    ID_COLOR_WHISFROM   As Long 'EVENT SID_WHISPFROM
    ID_COLOR_WHISTO     As Long 'EVENT SID_WHISPTO
    ID_COLOR_WHISP_NAME As Long 'Coloring of the name during a WHISPFROM or WHISPTO event
    ID_COLOR_JOIN       As Long 'EVENT SID_JOIN
    ID_COLOR_LEAVE      As Long 'EVENT SID_LEAVE
    ID_COLOR_USER       As Long 'EVENT SID_USER
    
    ID_COLOR_TIME       As Long 'TIMESTAMP
    ID_COLOR_TEXT       As Long 'Message of a user or general text by the bot.
    ID_COLOR_NAMES      As Long 'Color of the username of the event
    ID_COLOR_NAMES_2    As Long 'Acts as an alternate color to help distinguish chat.
    
    ID_COLOR_PROCESS    As Long 'Action is being processed
    ID_COLOR_SUCCEED    As Long 'Action follows through
    ID_COLOR_FAILED     As Long 'Action does not follow through or on error
    
    ID_COLOR_OPERATOR   As Long 'Fore color of User in channellist => Operator
    ID_COLOR_SQUELCH    As Long 'Fore color of User in channellist => Squelched user
    ID_COLOR_BLIZZARD   As Long 'Fore color of User in channellist => Blizzard Employee
    ID_COLOR_NORMAL     As Long 'Fore color of User in channellist => No flags attached
     
    ID_COLOR_SELF       As Long 'Color for when the user talks themselves.
    ID_COLOR_BRACKET    As Long 'Color for chat message if using brackets is on.
    
    'Bot Colors
    BOT_COLOR_INFO      As Long
    BOT_COLOR_ERROR     As Long

    BOT_COLOR_PROCESS   As Long
    BOT_COLOR_SUCCEED   As Long
    BOT_COLOR_FAILED    As Long
    
    'GUI Colors:
    'Back colors
    'BACK_MAIN           As Long
    
    'BACK_LABEL          As Long
    'BACK_CHANLIST       As Long
    'BACK_FRIENDLIST     As Long
    'BACK_CLANLIST       As Long

    'BACK_LEFTTEXT       As Long
    'BACK_MIDTEXT        As Long
    'BACK_RIGHTTEXT      As Long

    'BACK_CHATRTB        As Long
    'BACK_WHISPRTB       As Long
        
    'Fore colors
    'FORE_LABEL          As Long

    'FORE_LEFTTEXT       As Long
    'FORE_MIDTEXT        As Long
    'FORE_RIGHTTEXT      As Long
        
    'Strictly Debug Mode Colors:
    DBG_SENT           As Long
    DBG_RECEIVED       As Long
End Type

Public Sub setDefaultGUIColors()
    
    'Battle.net Colors:
    COLORS.ID_COLOR_INFO = RGB(98, 128, 201)
    COLORS.ID_COLOR_EMOTE = RGB(245, 201, 8)
    COLORS.ID_COLOR_TALK = RGB(255, 255, 255)
    COLORS.ID_COLOR_WHISFROM = RGB(136, 136, 136)
    COLORS.ID_COLOR_WHISTO = RGB(114, 114, 114)
    COLORS.ID_COLOR_WHISP_NAME = RGB(100, 100, 100)
    COLORS.ID_COLOR_JOIN = RGB(128, 128, 128)
    COLORS.ID_COLOR_LEAVE = RGB(112, 112, 112)
    COLORS.ID_COLOR_USER = RGB(128, 128, 128)
    
    COLORS.ID_COLOR_TIME = RGB(214, 214, 214)
    COLORS.ID_COLOR_TEXT = RGB(255, 255, 255)
    COLORS.ID_COLOR_NAMES = RGB(245, 201, 8)
    COLORS.ID_COLOR_NAMES_2 = RGB(174, 143, 5)
    
    COLORS.ID_COLOR_FAILED = RGB(124, 0, 0)
    COLORS.ID_COLOR_SUCCEED = RGB(0, 128, 0)
    COLORS.ID_COLOR_PROCESS = RGB(245, 201, 8)
    
    COLORS.ID_COLOR_OPERATOR = RGB(146, 102, 41)
    COLORS.ID_COLOR_BLIZZARD = RGB(98, 128, 201)
    COLORS.ID_COLOR_SQUELCH = RGB(187, 21, 21)
    COLORS.ID_COLOR_NORMAL = RGB(255, 255, 255)
    
    COLORS.ID_COLOR_SELF = RGB(202, 175, 57)
    COLORS.ID_COLOR_BRACKET = RGB(48, 119, 140)
     
    'Bot Colors:
    COLORS.BOT_COLOR_ERROR = RGB(124, 0, 0)
    COLORS.BOT_COLOR_FAILED = RGB(124, 0, 0)
    COLORS.BOT_COLOR_INFO = RGB(98, 128, 201)
    COLORS.BOT_COLOR_PROCESS = RGB(245, 201, 8)
    COLORS.BOT_COLOR_SUCCEED = RGB(0, 128, 0)
     
End Sub

Private Sub Read_RGB_Value(ByRef arrayColor() As String, ByVal strColor As String)
    On Error Resume Next
    'Split by commas first rgb value = first split value. Example String: 255,255,255
    Dim i As Integer
    strColor = Replace$(strColor, Space(1), vbNullString)
    arrayColor(0) = Split(strColor, ",")(0)
    arrayColor(1) = Split(strColor, ",")(1)
    arrayColor(2) = Split(strColor, ",")(2)
    For i = 0 To 2 'Fall back method
        If (arrayColor(i) = Empty) Or (arrayColor(i) = vbNullString) Or (arrayColor(i) > 255) Or (arrayColor(i) < 0) Then
            arrayColor(i) = 255
        End If
    Next i
End Sub

Public Sub setColorValue(ByVal strColorID As String, ByVal strColor As String)
    Dim rgbValue(2) As String
    Dim ColorValue As Long
    
    If (InStr(strColor, ",")) Then 'If the user is using a RGB value
        'Copy RGB values into an array
        Read_RGB_Value rgbValue(), strColor
        ColorValue = RGB(CInt(rgbValue(0)), CInt(rgbValue(1)), CInt(rgbValue(2)))
    Else                           'If user is using some other long value
        ColorValue = CLng(Val(strColor))
    End If
    
    'Set color values according to their ID
    Select Case UCase$(strColorID)
        Case "ID_COLOR_INFO"
            COLORS.ID_COLOR_INFO = ColorValue
        Case "ID_COLOR_EMOTE"
            COLORS.ID_COLOR_EMOTE = ColorValue
        Case "ID_COLOR_TALK"
            COLORS.ID_COLOR_TALK = ColorValue
        Case "ID_COLOR_WHISFROM"
            COLORS.ID_COLOR_WHISFROM = ColorValue
        Case "ID_COLOR_WHISTO"
            COLORS.ID_COLOR_WHISTO = ColorValue
        Case "ID_COLOR_WHISP_NAME"
            COLORS.ID_COLOR_WHISP_NAME = ColorValue
        Case "ID_COLOR_JOIN"
            COLORS.ID_COLOR_JOIN = ColorValue
        Case "ID_COLOR_LEAVE"
            COLORS.ID_COLOR_LEAVE = ColorValue
        Case "ID_COLOR_USER"
            COLORS.ID_COLOR_USER = ColorValue
        Case "ID_COLOR_TIME"
            COLORS.ID_COLOR_TIME = ColorValue
        Case "ID_COLOR_TEXT"
            COLORS.ID_COLOR_TEXT = ColorValue
        Case "ID_COLOR_NAMES"
            COLORS.ID_COLOR_NAMES = ColorValue
        Case "ID_COLOR_SUCCEED"
            COLORS.ID_COLOR_SUCCEED = ColorValue
        Case "ID_COLOR_FAILED"
            COLORS.ID_COLOR_FAILED = ColorValue
        Case "ID_COLOR_PROCESS"
            COLORS.ID_COLOR_PROCESS = ColorValue
        Case "ID_COLOR_OPERATOR"
            COLORS.ID_COLOR_OPERATOR = ColorValue
        Case "ID_COLOR_SQUELCH"
            COLORS.ID_COLOR_SQUELCH = ColorValue
        Case "ID_COLOR_BLIZZARD"
            COLORS.ID_COLOR_BLIZZARD = ColorValue
        Case "ID_COLOR_NORMAL"
            COLORS.ID_COLOR_NORMAL = ColorValue
        Case "ID_COLOR_SELF"
            COLORS.ID_COLOR_SELF = ColorValue
        Case "ID_COLOR_BRACKET"
            COLORS.ID_COLOR_BRACKET = ColorValue
        Case "ID_COLOR_NAMES_2"
            COLORS.ID_COLOR_NAMES_2 = ColorValue
        Case "BOT_COLOR_INFO"
            COLORS.BOT_COLOR_INFO = ColorValue
        Case "BOT_COLOR_ERROR"
            COLORS.BOT_COLOR_ERROR = ColorValue
        Case "BOT_COLOR_PROCESS"
            COLORS.BOT_COLOR_PROCESS = ColorValue
        Case "BOT_COLOR_SUCCEED"
            COLORS.BOT_COLOR_SUCCEED = ColorValue
        Case "BOT_COLOR_FAILED"
            COLORS.BOT_COLOR_FAILED = ColorValue
        Case Else
            AddC BotIndex, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "[Error] Unknown color value: " & strColorID
    End Select
End Sub
